//begin
//
//
package 
{
	//
	//
	//
	import flash.display.MovieClip;
	import flash.display.Loader;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.display.Shape;
	import flash.media.Sound;
	import flash.net.URLRequest;
	import flash.events.*
	import flash.utils.*;
	//
	import logic.InteractivePointLogic;
	import flash.display.Shape;
	import flash.display.Sprite;
	//
	//
	//
	public class FootballGame extends MovieClip
	{
		//
		//
		private var moveTimer:Timer;
		//
		private var hasSkin:Boolean;
		private var hasSound:Boolean;
		private var ballSkinLO:Loader;
		private var ballSkinSP:Sprite;
		private var ballPopSND:Sound;
		private var ballPoint:InteractivePointLogic;
		private var myBackSP:Sprite;
		//
		private var xspeed:Number;
		private var yspeed:Number;
		private var oldx:Number;
		private var oldy:Number;
		//
		//
		//
		public function FootballGame ( )
		{
			//
			stage.frameRate = 25;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP;
			//
			myBackSP = new Sprite( );
			myBackSP.graphics.beginFill( 0x900000 , 1 );
			myBackSP.graphics.lineStyle( 2 , 0xffffff , 1 );
			myBackSP.graphics.moveTo( 0 , 0 );
			myBackSP.graphics.lineTo( 400 , 0 );
			myBackSP.graphics.lineTo( 400 , 200 );
			myBackSP.graphics.lineTo( 0 , 200 );
			myBackSP.graphics.lineTo( 0 , 0 );
			addChild( myBackSP );	
			//
			loadSkin( );
			loadSound( );
			//
			addLog( "new FootballGame" );
			//
		}
		//
		//
		//
		public function loadSkin ( ):void
		{
			//
			ballSkinSP = new Sprite( );
			addChild( ballSkinSP );
			//
			var urlRequest:URLRequest = new URLRequest( "soccerball.gif" );
			ballSkinLO = new Loader( );
			ballSkinLO.contentLoaderInfo.addEventListener( Event.COMPLETE , skinLoaded );
			ballSkinLO.contentLoaderInfo.addEventListener( IOErrorEvent.IO_ERROR , ioErrorHandler );
			ballSkinLO.load( urlRequest );
			ballSkinSP.addChild( ballSkinLO );
			//
			addLog( "FootballGame.loadSkin" );
			//
		}
		//
		//
		//
		public function loadSound ( ):void
		{
			//
			var urlRequest:URLRequest = new URLRequest( "pop.mp3" );
			ballPopSND = new Sound( );
			ballPopSND.addEventListener( Event.COMPLETE , soundLoaded );
            ballPopSND.addEventListener( IOErrorEvent.IO_ERROR , ioErrorHandler );
			ballPopSND.load( urlRequest );
			//
			addLog( "FootballGame.loadSoun" );
			//
		}
		//
		//
		//
		public function ioErrorHandler ( eventOBJ:Event ):void
		{
			//
			addLog( "ioError: " + eventOBJ );
			//
		}
		//
		//
		//
		public function skinLoaded ( eventOBJ:Event ):void
		{
			//
			ballSkinLO.x = -20;
			ballSkinLO.y = -20;
			ballSkinLO.width = 40;
			ballSkinLO.height = 40;
			hasSkin = true;
			initLogic( );
			//
			addLog( "FootballGame.skinLoaded" );
			//
		}
		//
		//
		//
		public function soundLoaded ( eventOBJ:Event ):void
		{
			//
			hasSound = true;
			initLogic( );
			//
			addLog( "FootballGame.soundLoaded" );
			//
		}
		//
		//
		//
		public function initLogic ( ):void
		{
			//
			if ( hasSkin && hasSound )
			{
				//
				ballPoint = new InteractivePointLogic( this );
				ballPoint.xpos = 20;
				ballPoint.ypos = 20;
				ballPoint.xspeed = Math.random( )*5;
				ballPoint.yspeed = Math.random( )*5;
				ballPoint.setSkin( ballSkinSP );
				ballPoint.setSound( ballPopSND );
				//
				moveTimer = new Timer( 25 );
				moveTimer.addEventListener( TimerEvent.TIMER , ballPoint.step );
				moveTimer.start( );
				//
			}
			//
			addLog( "FootbalGame.initLogic " + hasSkin + " " + hasSound );
			//
		}
		//
		//
		//
		public function dragBall ( ):void
		{
			//
			addEventListener( MouseEvent.MOUSE_MOVE , moveBall );
			moveTimer.stop( );
			//
			addLog( "FootbalGame.dragBall" );
			//
		}
		//
		//
		//
		public function releaseBall ( ):void
		{
			//
			removeEventListener( MouseEvent.MOUSE_MOVE , moveBall );
			ballPoint.xspeed = xspeed;
			ballPoint.yspeed = yspeed;
			moveTimer.start( );
			//
			addLog( "FootbalGame.releaseBall" );
			//
		}
		//
		//
		//
		public function moveBall ( eventOBJ:MouseEvent ):void
		{
			//
			ballPoint.xpos = mouseX;
			ballPoint.ypos = mouseY;
			ballPoint.updateSkin( );
			//
			xspeed = mouseX - oldx;
			yspeed = mouseY - oldy;
			//
			oldx = mouseX;
			oldy = mouseY;
			//
			addLog( "FootbalGame.moveBall" + mouseX + " " + mouseY );
			//
		}	
		//
		//
		//
		public function addLog( logText:String ):void
		{
			//
			trace( logText );
			//
		}
		//
		//
		//
	}
	//
	//
	//
}
//
//
//end