package logic
{
	//
	//
	//
	import flash.display.MovieClip;
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.media.Sound;
	import flash.events.*;
	//
	//
	//
	public class InteractivePointLogic
	{
		//
		//
		//
		private var father:Object;
		private var gravity:Number = 0.5;
		private var skinSP:Sprite;
		private var ballSND:Sound;
		//
		public var xpos:Number;
		public var ypos:Number;
		public var xspeed:Number;
		public var yspeed:Number;
		//
		//
		//
		public function InteractivePointLogic ( myRoot:MovieClip )
		{
			//
			father = myRoot;
			addLog( "new InteractivePointLogic" );
			//
		}
		//
		//
		//
		public function setSkin ( mySP:Sprite ):void
		{
			//
			skinSP = mySP;
			skinSP.addEventListener( MouseEvent.MOUSE_DOWN , mouseDownHandler );
			skinSP.addEventListener( MouseEvent.MOUSE_UP , mouseUpHandler );
			//
			addLog( "InteractivePointLogic.setSkin " + mySP );
			//
		}
		//
		//
		//
		public function updateSkin ( ):void
		{
			//
			skinSP.x = xpos;
			skinSP.y = ypos;
			skinSP.rotation += xspeed;
			//
			//addLog( "InteractivePointLogic.updateSkin" );
			//
		}
		//
		//
		//
		public function setSound ( mySND:Sound ):void
		{
			//
			ballSND = mySND;
			//
			addLog( "InteractivePointLogic.setSound " + mySND );			
			//
		}
		//
		//
		//
		public function step ( timeEvent:TimerEvent ):void
		{
			//
			yspeed += gravity;
			//
			if ( xpos + xspeed > 390 ) 
			{
				//
				ballSND.play( );
				xspeed *= -1;
				//
			}
			//
			if ( xpos + xspeed < 10 ) 
			{
				//
				ballSND.play( );
				xspeed *= -1;
				//
			}
			//
			if ( ypos + yspeed > 190 ) 
			{
				//
				ballSND.play( );
				yspeed -= gravity;
				yspeed *= -1;
				//
			}
			//
			if ( ypos + yspeed < 10 )
			{
				//
				ballSND.play( );
				yspeed *= -1;
				//
			}				
			//
			xpos += xspeed;
			ypos += yspeed;
			//
			updateSkin( );
			//
			//addLog( "InteractivePointLogic.step" );			
			//
		}
		//
		//
		//
		public function mouseDownHandler ( eventOBJ:MouseEvent ):void
		{
			//
			father.dragBall( );
			//
		}
		//
		//
		//
		public function mouseUpHandler ( eventOBJ:MouseEvent ):void
		{
			//
			father.releaseBall( );
			//
		}
		//
		//
		//
		private function addLog ( logText:String ):void
		{
			//
			father.addLog( logText );
			//
		}
		//
		//
		//
	}
	//
	//
	//
}
//
//
//end