//begin
//
//
package 
{
	//
	//
	//
	import flash.media.Video;
	import flash.display.Bitmap;
	import flash.display.MovieClip;
	import flash.display.Loader;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.media.Sound;
	import flash.net.URLRequest;
	import flash.events.*
	import flash.utils.*;
	//
	import logic.MotionDetectorLogic;
	import logic.InteractivePointLogic;
	import flash.display.Sprite;
	import flash.media.Camera;
	//
	//
	//
	public class FootballGame extends Sprite
	{
		//
		//
		private var moveTimer:Timer;
		//
		private var hasSkin:Boolean;
		private var hasSound:Boolean;
		private var ballSkinLO:Loader;
		private var ballSkinSP:Sprite;
		private var ballPopSND:Sound;
		private var ballPoint:InteractivePointLogic;
		//
		public  var RADIUS:Number = 20;
		public var WIDTH:int = 320;
		public var HEIGHT:int = 240;
		//
		private var xspeed:Number;
		private var yspeed:Number;
		private var oldx:Number;
		private var oldy:Number;
		//
		private var motDetOBJ:MotionDetectorLogic;
		private var movieVID:Video;
		private var movieBMP:Bitmap;
		private var movieCAM:Camera;
		//
		//
		//
		public function FootballGame ( )
		{
			//
			stage.frameRate = 25;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			stage.align = StageAlign.TOP;
			//
			movieVID = new Video( );
			movieBMP = new Bitmap( );
			movieCAM = Camera.getCamera( );
			movieVID.attachCamera( movieCAM );
			addChild( movieVID );
			addChild( movieBMP );
			//
			motDetOBJ = new MotionDetectorLogic( this );
			motDetOBJ.setVideo( movieVID );
			motDetOBJ.setBitmap( movieBMP );
			//
			loadSkin( );
			loadSound( );
			//
			addLog( "new FootballGame" );
			//
		}
		//
		//
		//
		public function loadSkin ( ):void
		{
			//
			ballSkinSP = new Sprite( );
			addChild( ballSkinSP );
			//
			var urlRequest:URLRequest = new URLRequest( "soccerball.gif" );
			ballSkinLO = new Loader( );
			ballSkinLO.contentLoaderInfo.addEventListener( Event.COMPLETE , skinLoaded );
			ballSkinLO.contentLoaderInfo.addEventListener( IOErrorEvent.IO_ERROR , ioErrorHandler );
			ballSkinLO.load( urlRequest );
			ballSkinSP.addChild( ballSkinLO );
			//
			addLog( "FootballGame.loadSkin" );
			//
		}
		//
		//
		//
		public function loadSound ( ):void
		{
			//
			var urlRequest:URLRequest = new URLRequest( "pop.mp3" );
			ballPopSND = new Sound( );
			ballPopSND.addEventListener( Event.COMPLETE , soundLoaded );
            ballPopSND.addEventListener( IOErrorEvent.IO_ERROR , ioErrorHandler );
			ballPopSND.load( urlRequest );
			//
			addLog( "FootballGame.loadSoun" );
			//
		}
		//
		//
		//
		public function ioErrorHandler ( eventOBJ:Event ):void
		{
			//
			addLog( "ioError: " + eventOBJ );
			//
		}
		//
		//
		//
		public function skinLoaded ( eventOBJ:Event ):void
		{
			//
			ballSkinLO.x = -RADIUS;
			ballSkinLO.y = -RADIUS;
			ballSkinLO.width = 2*RADIUS;
			ballSkinLO.height = 2*RADIUS;
			hasSkin = true;
			initLogic( );
			//
			addLog( "FootballGame.skinLoaded" );
			//
		}
		//
		//
		//
		public function soundLoaded ( eventOBJ:Event ):void
		{
			//
			hasSound = true;
			initLogic( );
			//
			addLog( "FootballGame.soundLoaded" );
			//
		}
		//
		//
		//
		public function initLogic ( ):void
		{
			//
			if ( hasSkin && hasSound )
			{
				//
				ballPoint = new InteractivePointLogic( this );
				ballPoint.xpos = 20;
				ballPoint.ypos = 20;
				ballPoint.xspeed = Math.random( )*5;
				ballPoint.yspeed = Math.random( )*5;
				ballPoint.setSkin( ballSkinSP );
				ballPoint.setSound( ballPopSND );
				//
				moveTimer = new Timer( 25 );
				moveTimer.addEventListener( TimerEvent.TIMER , step );
				moveTimer.start( );
				//
			}
			//
			addLog( "FootbalGame.initLogic " + hasSkin + " " + hasSound );
			//
		}
		//
		//
		//
		public function step ( eventOBJ:Event ):void
		{
			//
			var diffARR:Array = motDetOBJ.getPoints( );
			//
			for ( var a:int = 0 ; a < diffARR.length ; ++a )
			{
				//
				var dx:Number = ballPoint.xpos - diffARR[a].x;
				var dy:Number = ballPoint.ypos - diffARR[a].y;
				var dr:Number = Math.sqrt( dx*dx + dy*dy );
				//
				if ( dr < RADIUS )
				{
					//
					ballPoint.xspeed = dx;
					ballPoint.yspeed = dy;
					break;
					//
				}
				//
			}
			//
			ballPoint.step( );
			//
		}
		//
		//
		//
		public function dragBall ( ):void
		{
			//
			addEventListener( MouseEvent.MOUSE_MOVE , moveBall );
			moveTimer.stop( );
			//
			addLog( "FootbalGame.dragBall" );
			//
		}
		//
		//
		//
		public function releaseBall ( ):void
		{
			//
			removeEventListener( MouseEvent.MOUSE_MOVE , moveBall );
			ballPoint.xspeed = xspeed;
			ballPoint.yspeed = yspeed;
			moveTimer.start( );
			//
			addLog( "FootbalGame.releaseBall" );
			//
		}
		//
		//
		//
		public function moveBall ( eventOBJ:MouseEvent ):void
		{
			//
			ballPoint.xpos = mouseX;
			ballPoint.ypos = mouseY;
			ballPoint.updateSkin( );
			//
			xspeed = mouseX - oldx;
			yspeed = mouseY - oldy;
			//
			oldx = mouseX;
			oldy = mouseY;
			//
			addLog( "FootbalGame.moveBall" + mouseX + " " + mouseY );
			//
		}	
		//
		//
		//
		public function addLog( logText:String ):void
		{
			//
			trace( logText );
			//
		}
		//
		//
		//
	}
	//
	//
	//
}
//
//
//end