package logic
{
	//
	//
	//
	import flash.display.Sprite;
	import flash.display.Loader;
	import flash.media.Sound;
	import flash.events.*;
	//
	//
	//
	public class InteractivePointLogic
	{
		//
		//
		//
		private var father:Object;
		private var gravity:Number = 0.5;
		private var skinSP:Sprite;
		private var ballSND:Sound;
		//
		public var xpos:Number;
		public var ypos:Number;
		public var xspeed:Number;
		public var yspeed:Number;
		//
		//
		//
		public function InteractivePointLogic ( myRoot:Sprite )
		{
			//
			father = myRoot;
			addLog( "new InteractivePointLogic" );
			//
		}
		//
		//
		//
		public function setSkin ( mySP:Sprite ):void
		{
			//
			skinSP = mySP;
			skinSP.addEventListener( MouseEvent.MOUSE_DOWN , mouseDownHandler );
			skinSP.addEventListener( MouseEvent.MOUSE_UP , mouseUpHandler );
			//
			addLog( "InteractivePointLogic.setSkin " + mySP );
			//
		}
		//
		//
		//
		public function updateSkin ( ):void
		{
			//
			skinSP.x = xpos;
			skinSP.y = ypos;
			skinSP.rotation += xspeed;
			//
			//addLog( "InteractivePointLogic.updateSkin" );
			//
		}
		//
		//
		//
		public function setSound ( mySND:Sound ):void
		{
			//
			ballSND = mySND;
			//
			addLog( "InteractivePointLogic.setSound " + mySND );			
			//
		}
		//
		//
		//
		public function step ( ):void
		{
			//
			yspeed += gravity;
			//
			if ( xpos + xspeed > father.WIDTH - father.RADIUS ) 
			{
				//
				ballSND.play( );
				xspeed *= -.9;
				//
			}
			//
			if ( xpos + xspeed < 0 + father.RADIUS ) 
			{
				//
				ballSND.play( );
				xspeed *= -.9;
				//
			}
			//
			if ( ypos + yspeed > father.HEIGHT - father.RADIUS - 20 ) 
			{
				//
				ballSND.play( );
				yspeed -= gravity;
				yspeed *= -.9;
				//
			}
			//
			if ( ypos + yspeed < 0 + father.RADIUS )
			{
				//
				ballSND.play( );
				yspeed *= -.9;
				//
			}				
			//
			xpos += xspeed;
			ypos += yspeed;
			//
			updateSkin( );
			//
			//addLog( "InteractivePointLogic.step" );			
			//
		}
		//
		//
		//
		public function mouseDownHandler ( eventOBJ:MouseEvent ):void
		{
			//
			father.dragBall( );
			//
		}
		//
		//
		//
		public function mouseUpHandler ( eventOBJ:MouseEvent ):void
		{
			//
			father.releaseBall( );
			//
		}
		//
		//
		//
		private function addLog ( logText:String ):void
		{
			//
			father.addLog( logText );
			//
		}
		//
		//
		//
	}
	//
	//
	//
}
//
//
//end