//begin
//
//
package logic
{
	//
	//
	//
	import flash.display.BitmapData;
	import flash.display.Bitmap;
	import flash.media.Video;
	//
	import flash.geom.Rectangle;
	import flash.geom.ColorTransform;
	//
	import flash.filters.ColorMatrixFilter;
	//
	//
	//
	public class MotionDetectorLogic
	{
		//
		//
		//
		private var root:Object;
		//
		private var difColTR:ColorTransform;
		private var actBMP:BitmapData;
		private var oldBMP:BitmapData;
		private var difBMP:BitmapData;
		private var myBMP:Bitmap;
		private var myVID:Video;
		//
		private var SENSITIVITY:int = 700000;
		private var BLOCKSIZE:int = 10;
		//
		//
		//
		public function MotionDetectorLogic ( myRoot:Object ):void
		{
			//
			root = myRoot;
			//
			difColTR = new ColorTransform( 1 , 1 , 1 , .7 , 0 , 0 , 0 , 0 );
			//
			actBMP = new BitmapData( 320 , 240 , false , 0x000000 );
			oldBMP = new BitmapData( 320 , 240 , false , 0x000000 );
			difBMP = new BitmapData( 320 , 240 , true , 0x000000 );
			//
			addLog( "new MotionDetectorLogic " );
			//
		}
		//
		//
		//
		public function setVideo ( vidOBJ:Video ):void
		{
			//
			myVID = vidOBJ;
			//
			addLog( "MotionDetectorLogic.setVideo " + vidOBJ );
			//
		}
		//
		//
		//
		public function setBitmap ( bmpOBJ:Bitmap ):void
		{
			//
			myBMP = bmpOBJ;
			myBMP.bitmapData = difBMP;
			//
			addLog( "MotionDetectorLogic.setBitmap " + bmpOBJ );
			//
		}
		//
		//
		//
		public function getPoints ( ):Array
		{
			//
			difBMP.colorTransform( difBMP.rect , difColTR );
			actBMP.draw( myVID );
			//
			var diffPoints:Array = [ ];
			//
			for ( var a:int = 0 ; a < actBMP.width ; a += BLOCKSIZE )
			 for ( var b:int = 0 ; b < actBMP.height ; b += BLOCKSIZE )
			 {
			 	//
			 	var oldPx:uint = oldBMP.getPixel( a , b );
			 	var newPx:uint = actBMP.getPixel( a , b );
			 	//
			 	if ( ( oldPx - SENSITIVITY ) > newPx || ( oldPx + SENSITIVITY ) < newPx ) 
			 		diffPoints.push( { x:a , y:b } );
			 	//
			 }
			//
			oldBMP = actBMP.clone( );
			drawDifference( diffPoints );
			//
			//addLog( "MotionDetectorLogic.getPoints " + diffPoints );
			//
			return diffPoints;
			//
		}
		//
		//
		//
		public function drawDifference ( diffPoints:Array ):void
		{
			//
			for ( var a:int = 0 ; a < diffPoints.length ; ++a )
			{
				//
				var p:Object = diffPoints[a];
				var rect:Rectangle = new Rectangle( p.x , p.y , BLOCKSIZE , BLOCKSIZE ); 
				difBMP.fillRect( rect , 0xff00ff00 ); 
				//
			}
			//
			//addLog( "MotionDetectorLogic.drawDifference" );
			//
		}
		//
		//
		//
		public function addLog ( logText:String ):void
		{
			//
			this.root.addLog( logText );
			//
		}
		//
		//
		//
	}
	//
	//
	//
}
//
//
//end