//begin
//
//
package
{
	//
	//
	//
	import flash.net.URLRequest;
	import flash.display.StageScaleMode;
	import flash.display.StageAlign;
	import flash.display.Loader;
	import flash.display.Sprite;
	import flash.display.MovieClip;
	import flash.display.DisplayObject;
	import flash.text.TextField;
	import flash.geom.Point;
	import flash.events.*;
	import flash.utils.*;
	//
	import com.milgra.display.VectorDrawer;
	import com.milgra.geometry.Vector;
	import com.milgra.geometry.VectorOperator;
	//
	public class VectorTest extends Sprite
	{
		//
		//
		//
		private var skinLO:Loader;
		private var skinMC:MovieClip;
		private var dispSP:Sprite;
		private var startBTN:MovieClip;
		private var perdelTF:TextField;
		private var linedelTF:TextField;
		private var cyclesTF:TextField;
		private var linesTF:TextField;
		private var pointsTF:TextField;
		//
		private var cycles:uint = 100000;
		private var vectorArr:Array;
		private var cpointArr:Array;
		private var vDrawer:VectorDrawer;
		private var vOperator:VectorOperator;
		//
		//
		//
		public function VectorTest ( )
		{
			//
			trace( "new VectorTest" );
			//
			stage.stageWidth = 550;
			stage.stageHeight = 400;
			stage.align = StageAlign.TOP;
			stage.scaleMode = StageScaleMode.NO_SCALE;
			//
			var skinURL:URLRequest = new URLRequest( "vectortestskin.swf" );
			skinLO = new Loader( );
			skinLO.contentLoaderInfo.addEventListener( "complete" , initSkin );
			skinLO.contentLoaderInfo.addEventListener( "httpStatus" , statusEvent );
			skinLO.contentLoaderInfo.addEventListener( "ioError" , errorEvent );
			skinLO.load( skinURL );
			addChild( skinLO );
			//
		}
		//
		//
		//
		public function statusEvent ( eventOBJ:Event ):void
		{
			//
			addLog( "statusEvent: " + eventOBJ );
			//	
		}
		//
		//
		//
		public function errorEvent ( eventOBJ:Event ):void
		{
			//
			addLog( "errorEvent: " + eventOBJ );
			//	
		}
		//
		//
		//
		public function initSkin ( eventOBJ:Event ):void
		{
			//
			addLog( "initSkin: " + eventOBJ );
			//
			skinMC = skinLO.content as MovieClip;
			startBTN = skinMC.startBTN;
			perdelTF = skinMC.perdelTF;
			linedelTF = skinMC.linedelTF;
			cyclesTF = skinMC.cyclesTF;
			linesTF = skinMC.linesTF;
			pointsTF = skinMC.pointsTF;
			//
			dispSP = new MovieClip( );
			skinMC.addChildAt( dispSP , 1 );
			//
			cyclesTF.text = String( cycles );
			linesTF.text = "false";
			pointsTF.text = "false";
			//
			startBTN.labelTF.text = "Start";
			startBTN.buttonMode = true;
			startBTN.mouseChildren = false;
			startBTN.addEventListener( "click" , startTest );
			//
		}
		//
		//
		//
		public function startTest( eventOBJ:Event ):void
		{
			//
			//addLog( "startTest: " + eventOBJ );
			//
			var time1:Number;
			var time2:Number;
			//
			dispSP.graphics.clear();
			vDrawer = new VectorDrawer( dispSP );
			vOperator = new VectorOperator( );
			vectorArr = [ ];
			cpointArr = [ ];
			//
			cycles = int( cyclesTF.text );
			if ( cycles > 5000 && linesTF.text == "true" ) 
			{
				cycles = 1000;
				cyclesTF.text = String( cycles );
			}
			//
			time1 = ( new Date( ) ).time;
			for ( var a:uint = 0 ; a < cycles ; ++a ) perTest( );
			time2 = ( new Date( ) ).time;
			//
			var txt1:String = String( time2 - time1 );
			perdelTF.text = txt1 + "ms";
			//
			time1 = ( new Date( ) ).time;
			for ( var a:uint = 0 ; a < cycles ; ++a ) lineTest( );
			time2 = ( new Date( ) ).time;
			//
			var txt2:String = String( time2 - time1 );
			linedelTF.text = txt2 + "ms";
			//
			if ( linesTF.text == "true" ) vDrawer.drawVectors( vectorArr );
			if ( pointsTF.text == "true" ) vDrawer.drawPoints( cpointArr );
			//
		}
		//
		//
		//
		public function perTest ( ):void
		{
			//
			var v1:Vector = new Vector ( ranNum( 550 ) , ranNum( 400 ) , ranNum( 550 ) , ranNum( 400 ) );
			var v2:Vector = new Vector ( ranNum( 550 ) , ranNum( 400 ) , ranNum( 550 ) , ranNum( 400 ) );
			vectorArr.push( v1 );
			vectorArr.push( v2 );
			//
			var cp:Point = vOperator.getPerIntersection( v1 , v2 );
			cpointArr.push( cp );
			//
		}		
		//
		//
		//
		public function lineTest ( ):void
		{
			//
			var v1:Vector = new Vector ( ranNum( 550 ) , ranNum( 400 ) , ranNum( 550 ) , ranNum( 400 ) );
			var v2:Vector = new Vector ( ranNum( 550 ) , ranNum( 400 ) , ranNum( 550 ) , ranNum( 400 ) );
			vectorArr.push( v1 );
			vectorArr.push( v2 );
			//
			var cp:Point = vOperator.getLineIntersection( v1 , v2 );
			cpointArr.push( cp );
			//
		}
		//
		//
		//
		public function ranNum ( max:Number ):Number
		{
			//
			return  Math.random( )*max;
			//
		}
		//
		//
		//
		public function addLog ( logText:String ):void
		{
			//
			trace( logText );
			//
		}
		//
		//
		//
	}
	//
	//
	//
}
//
//
//end