<?PHP
// ************************************
// *     BlackY's Guardian Angel      *
// ************************************
// * This program is avaible over the *
// *             GNU / GPL            *
// *   license. More details can be   *
// *  found all over the internet ;)  *
// ************************************

include 'config.php';

// ********** DO NOT MODIFY BELOW THIS LINE *****************
// ****   OF COURSE, EXCEPT YOU KNOW WHAT YOU'RE DOING   ****


function bga_fill_ip($ip, $with = "")
	{
	if(strlen($ip) == 15)
		{
		return $ip;
		}
	else
		{
		$fragments = explode('.', $ip);
		$ip = '';
		foreach($fragments as $fragment)
			{
			switch(strlen($fragment))
				{
				case 1:
					if(IsSet($with))
						{
						$ip .= $with . $with . $fragment . '.';
						}
					else
						{
						$ip .= '00' . $fragment . '.';
						}
				break;
				case 2:
					if(IsSet($with))
						{
						$ip .= $with . $fragment . '.';
						}
					else
						{
						$ip .= '00' . $fragment . '.';
						}
				break;
				case 3:
					$ip .= $fragment . '.';
				break;
				}
			}
		}
	return substr($ip,0,15);
	}

function bga_create_mask($ip)
	{
	$ip = bga_fill_ip($ip, 'X');
	$ip = ereg_replace('X', "[0-9]{1}", $ip);
	return $ip;
	}

function bga_check()
	{
	global $cfg;
	$user_ip = bga_fill_ip(getenv('REMOTE_ADDR'), '0');
	if(!file_exists($cfg['filename']))
		{
		return false;
		}
	$fa = @fopen($cfg['filename'], 'r');
	if($fa === false)
		{
		return false;
		}
	while($line = fgets($fa, 1024))
		{
		$line = ereg_replace("\n", "", $line);
		$ip_mask = bga_create_mask($line);
		if(!Empty($ip_mask))
			{
			if(ereg($ip_mask, $user_ip))
				{
				return true;
				}
			}
		}
	return false;
	}

function bga_load_file($file = "")
	{
	global $cfg;
	if(!IsSet($_GET['bga_page']))
		{
		$_GET['bga_page'] = $cfg['front_page'];
		}
	if(IsSet($file) AND $file != "")
		{
		$_GET['bga_page'] = $file;
		}

	if(file_exists($cfg['document_dir'] . '/' . $_GET['bga_page'] . '.html'))
		{
		include $cfg['document_dir'] . '/' . $_GET['bga_page'] . '.html';
		exit;
		}
	if(file_exists($cfg['document_dir'] . '/' . $_GET['bga_page'] . '.htm'))
		{
		include $cfg['document_dir'] . '/' . $_GET['bga_page'] . '.htm';
		exit;
		}
	if(file_exists($cfg['document_dir'] . '/' . $_GET['bga_page'] . '.php'))
		{
		include $cfg['document_dir'] . '/' . $_GET['bga_page'] . '.php';
		exit;
		}
	if(file_exists($cfg['document_dir'] . '/404.html'))
		{
		include $cfg['document_dir'] . '/404.html';
		exit;
		}
	return false;
	}

function bga_allow($ip)
	{
	global $cfg;
	$fa = fopen($cfg['filename'], 'a');
	fwrite($fa, $ip . "\n");
	fclose($fa);
	}

function bga_ban($ip)
	{
	global $cfg;
	$fa = fopen($cfg['filename'], 'r');
	while($line = fgets($fa, 1024))
		{
		$line = ereg_replace("\n", '', $line);
		$ips[count($ips)] = $line;
		}
	fclose($fa);

	$fa = fopen($cfg['filename'], 'w');
	foreach($ips as $ip)
		{
		if($ip != $_POST['ip'])
			{
			fwrite($fa, $ip . "\n");
			}
		}
	fclose($fa);
	}

function bga_sort($file, $template="")
	{
	if(!file_exists($file) OR !is_readable($file))
		{
		return false;
		} 
	$fa = fopen($file,'r');
	while($data = fgets($fa, 1024))
		{
		$array[count($array)] = ereg_replace("\n", "", $data);
		}
	if(count($array) != 0)
		{
		natsort($array);
		foreach($array as $variable)
			{
			if($template == '')
				{
				$return .= $variable . "<br>\n";
				}
			else
				{
				$return .= ereg_replace('{VALUE}', $variable, $template) . "\n";
				}
			}
		return $return;
		}
	else
		{
		return false;
		}
	}
	
function bga_log_intrusion()
	{
	global $cfg;
	$fa = fopen($cfg['log_file'], 'a');
	fwrite($fa, date("Y-m-d H:i") . " : Possible intrusion from IP address " . getenv('REMOTE_ADDR') . "\n<br>\n");
	fclose($fa);
	}

header('Expires: 0');
header('Pragma: no-cache');

if($_GET['bga_page'] == 'admin')
	{
	if($_POST['adm_pass'] != $cfg['admin_pass'] AND $_COOKIE[$cfg['cookie_name']] != $cfg['admin_pass'])
		{
		bga_load_file('admin/login');
		exit;
		}
	else
		{
		if(IsSet($_POST['adm_pass']))
			{
			setcookie($cfg['cookie_name'], $_POST['adm_pass'], time()+3600);
			}
		elseif(IsSet($_COOKIE[$cfg['cookie_name']]))
			{
			setcookie($cfg['cookie_name'], $_COOKIE[$cfg['cookie_name']], time()+3600);
			}
		switch($_GET['subaction'])
			{
			case 'showlog':
				include $cfg['log_file'];
				print "<br><a href=\"index.php?bga_page=admin\">Vissza</a>";
				exit;
			break;
			case 'allow':
				if(IsSet($_POST['ip']))
					{
					bga_allow($_POST['ip']);
					}
				header("Location: index.php?bga_page=admin");
			break;
			case 'ban':
				if(IsSet($_POST['ip']))
					{
					bga_ban($_POST['ip']);
					}
				header("Location: index.php?bga_page=admin");
			break;
			case 'emptylog':
				$fa = fopen($cfg['log_file'], 'w');
				fclose($fa);
				header("Location: index.php?bga_page=admin");
			break;
			case 'logout':
				setcookie($cfg['cookie_name'], $_COOKIE[$cfg['cookie_name']], time()-3600);
				header("Location: index.php?bga_page=admin");
			break;
			}
			$fa = fopen($cfg['document_dir'] . '/admin/index.html', 'r');
			$contents = fread($fa, filesize($cfg['document_dir'] . '/admin/index.html'));
			fclose($fa);
			$contents = eregi_replace('<IPS>', "<select name=\"ip\" size=\"1\">\n" . bga_sort($cfg['filename'], "<OPTION value=\"{VALUE}\">{VALUE}</option>\n") . "</select>\n", $contents);
			$contents = eregi_replace('<OIP>', getenv('REMOTE_ADDR'), $contents);
			print $contents;
			exit;
		}
	}
else
	{
	if(!bga_check())
		{
		bga_log_intrusion();
		bga_load_file('503');
		}
	if(!bga_load_file())
		{
		bga_load_file('404');
		exit;
		}
	}