<?
/*
Plugin Name: incremental tag
Plugin URI: http://www.tutorial.hu
Description: Osszegzi a tageket, a post tegjeit hozza adja a már meglévő tagekhez, header-t készit, path-ot rajzol
Author: TLoF
Author URI: http://www.tutorial.hu
Version: 1.0
*/

function incremental_tags($before = 'The tags:', $sep = ', ', $after = '')
{
	$tag_array = get_page_tags();
	$posttags = get_the_tags();

	if ( empty( $posttags ) )
	{
		return false;
	}
	$tag_list = $before;

	if (is_array($tag_array))
	{
		foreach ($posttags as $tags)
		{
			if (!in_array($tags->slug, $tag_array))
			{
				$tag_links[] = '<a href="'.incremental_tag_link($tags->term_id, $tag_array).'" rel="tag">'.$tags->name.'</a>';
			}
		}
	}
	if (is_array($tag_links))
	{
		$tag_links = join( $sep, $tag_links );
		$tag_links = apply_filters( 'the_tags', $tag_links );
	}
	else
	{
		return false;
	}
	$tag_list .= $tag_links;

	$tag_list .= $after;

	echo $tag_list;
}

function incremental_tag_title()
{
	$tag_array = get_page_tags();
	if (is_array($tag_array))
	{
		foreach ($tag_array as $tag_slug)
		{
			$tag_object = get_term_by('slug', $tag_slug, 'post_tag', OBJECT, 'raw');
			$tag_name[] = $tag_object->name;
		}
	}
	if (is_array($tag_name))
	{
		echo implode(', ', $tag_name);
	}
	else
	{
		return false;
	}
}

function incremental_tag_path($before = 'Path:', $sep = ' >> ', $after = '')
{
	$tag_list = $before;

	$tag_array = get_page_tags();
	if (is_array($tag_array))
	{
		$tag_number = count($tag_array);
		for($runner = 0; $runner <= $tag_number; $runner++)
		{
			for($i = 0; $i <= $runner - 1; $i++)
			{
				$array[] = $tag_array[$i];
			}
			$tags = get_term_by('slug', $tag_array[$runner], 'post_tag', OBJECT, 'raw');
			$tag_links[] = '<a href="'.incremental_tag_link($tags->term_id, $array).'" rel="tag">'.$tags->name.'</a>';
			$array = array();
		}
		if (is_array($tag_links))
		{
			$tag_links = join( $sep, $tag_links );
			$tag_links = apply_filters( 'the_tags', $tag_links );
		}
		else
		{
			return false;
		}

		$tag_list .= $tag_links;

		$tag_list .= $after;

		echo $tag_list;
	}
	else
	{
		return false;
	}
}

function incremental_tag_link( $tag_id, $tag_array = '' ) {
	global $wp_rewrite;
	$taglink = $wp_rewrite->get_tag_permastruct();


	$tag = &get_term($tag_id, 'post_tag');

	if ( is_wp_error( $tag ) )
		return $tag;

	if (is_array($tag_array) and count($tag_array) >= 1)
	{
		$slug = implode('+', $tag_array) . '+' . $tag->slug;
	}
	else
	{
		$slug = $tag->slug;
	}

	if ( empty($taglink) )
	{
		$file = get_option('home') . '/';
		$taglink = $file . '?tag=' . $slug;
	}
	else
	{
		$taglink = str_replace('%tag%', $slug, $taglink);
		$taglink = get_option('home') . user_trailingslashit($taglink, 'category');
	}
	return apply_filters('tag_link', $taglink, $tag_id);
}

function get_page_tags()
{
	global $wp_rewrite;
	$taglink = $wp_rewrite->get_tag_permastruct();
	if ( empty($taglink) )
	{
		$tag_array = explode('+', $_GET['tag']);
	}
	else
	{
		$taglink = str_replace('%tag%', '', $taglink);
		$array = explode($taglink, $_SERVER['REQUEST_URI']);
		if (is_array($array) and isset($array[1]))
		{
			$tags = str_replace('/', '', $array[1]);
			$tag_array = explode('+', $tags);
		}

	}
	if (!isset($tag_array) or !is_array($tag_array))
	{
		$tag_array = array();
	}
	return $tag_array;
}

function header_tags($default = '')
{
	if (is_tag())
	{
		return incremental_tag_title();
	}
	else
	{
		$id = 0;
		$post = &get_post($id);
		$posttags = get_the_tags($post->ID);
		if ( empty( $posttags ) )
		{
			echo $default;
		}
		$echo = array();
		foreach ($posttags as $tag)
		{
			$echo[] = $tag->slug;
		}
		echo implode(', ', $echo);

	}
}

?>